% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cate.R
\name{cate}
\alias{cate}
\title{The main function for confounder adjusted testing}
\usage{
cate(X, Y, X.nuis = NULL, r, fa.method = c("ml", "pc", "esa"),
  adj.method = c("rr", "nc", "lqs", "naive"), psi = psi.huber, nc = NULL,
  nc.var.correction = TRUE, calibrate = TRUE)
}
\arguments{
\item{X}{treatment variable, n*d0 matrix}

\item{Y}{outcome, n*p matrix}

\item{X.nuis}{nuisance covarites, n*d1 matrix}

\item{r}{number of latent factors, can be estimated using the function \code{est.confounder.num}}

\item{fa.method}{factor analysis method}

\item{adj.method}{adjustment method}

\item{psi}{derivative of the loss function in robust regression}

\item{nc}{position of the negative controls,
if d0 > 1, this should be a matrix with 2 columns}

\item{nc.var.correction}{correct asymptotic variance based on our formula}

\item{calibrate}{if TRUE, use the Median and the Mean Absolute Deviation(MAD) to calibrate the test statistics}
}
\value{
a list of objects
\describe{
\item{alpha}{estimated alpha}
\item{alpha.p.value}{asymptotic p-value for the global chi squared test of alpha.}
\item{beta}{estimated beta}
\item{beta.cov.row}{estimated row covariance of \code{beta}}
\item{beta.cov.col}{estimated column covariance of \code{beta}}
\item{beta.t}{asymptotic z statistics for \code{beta}}
\item{beta.p.value}{asymptotic p-values for beta, based on \code{beta.t}}
\item{Y.tilde}{the transformed outcome matrix}
\item{Gamma}{estimated factor loadings}
\item{Z}{estimated latent factors}
\item{Sigma}{estimated noise variance matrix}
}
}
\description{
The main function for confounder adjusted testing
}
\details{
Ideally \code{nc} can either be a vector of numbers between 1 and p, if d0 = 1 or the negative controls are the same for every treatment variable, or a 2-column matrix specifying which positions of beta are known to be zero. But this is yet implemented.
}
\examples{
## simulate a dataset with 100 observations, 1000 variables and 5 confounders
data <- gen.sim.data(n = 100, p = 1000, r = 5)
## linear regression without any adjustment
output.naive <- cate(X = data$X1, Y = data$Y, X.nuis = NULL, r = 0, adj.method = "naive")
## confounder adjusted linear regression
output <- cate(X = data$X1, Y = data$Y, X.nuis = NULL, r = 5)
## plot the histograms of unadjusted and adjusted regression statistics
par(mfrow = c(1, 2))
hist(output.naive$beta.t)
hist(output$beta.t)
}
\references{
{
J. Wang, Q. Zhao, T. Hastie, and A. B. Owen (2015). Confounder adjustment in multiple testing. \emph{arXiv:1508.04178}.
}
}
\seealso{
\code{\link{wrapper}} for wrapper functions of some existing methods.
}

