% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{cochranQ}
\alias{cochranQ}
\title{Cochran's Q test}
\usage{
cochranQ(X, na.rm = TRUE, quiet = FALSE, digits = getOption("digits"))
}
\arguments{
\item{X}{matrix of \code{I} assessors (rows) and \code{J} products (columns)
where values are \code{0} (not checked) or \code{1} (checked)}

\item{na.rm}{should \code{NA} values be removed?}

\item{quiet}{if \code{FALSE} (default) then it prints information related to 
the test; if \code{TRUE} it returns only the test statistic (\code{Q})}

\item{digits}{significant digits (to display)}
}
\value{
Q test statistic
}
\description{
Calculate Cochran's Q test statistic. The null hypothesis that is assumed is 
that product proportions are all equal. The alternative hypothesis is that 
product proportions are not all equal.
}
\examples{
data(bread)

# Cochran's Q test on the first 25 consumers on the first attribute ("Fresh")
cochranQ(bread$cata[1:25,,1])
}
\references{
Cochran, W. G. (1950). The comparison of percentages in matched samples. 
\emph{Biometrika}, 37, 256-266.

Meyners, M., Castura, J.C., & Carr, B.T. (2013). Existing and  
new approaches for the analysis of CATA data. \emph{Food Quality and Preference}, 
30, 309-319, \doi{10.1016/j.foodqual.2013.06.010}
}
\seealso{
\code{\link[cata]{mcnemarQ}}
}
