% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{salton}
\alias{salton}
\title{Salton's cosine measure}
\usage{
salton(X, Y)
}
\arguments{
\item{X}{input matrix (same dimensions as \code{Y})}

\item{Y}{input matrix (same dimensions as \code{X})}
}
\value{
Salton's cosine measure
}
\description{
Calculate Salton's cosine measure
}
\examples{
# Generate some data
set.seed(123)
X <- matrix(rnorm(8), nrow = 4)
Y <- matrix(rnorm(8), nrow = 4)

# get Salton's cosine measure
salton(X, Y)
}
\references{
Salton, G., & McGill, M.J. (1983). \emph{Introduction to Modern 
Information Retrieval}. Toronto: McGraw-Hill.
}
