% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtexp}
\alias{dtexp}
\alias{ptexp}
\alias{qtexp}
\alias{rtexp}
\title{Density function of Truncated Exponential Distribution}
\usage{
dtexp(x, rate, min = 0, max = 1e+09)

ptexp(q, rate, min = 0, max = 1e+09)

qtexp(p, rate, min = 0, max = 1e+09)

rtexp(n, rate, min = 0, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{rate}{Distribution parameter}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Exponential Distribution

Cumulative probability function of Truncated Exponential Distribution

Quantile function of Truncated Exponential Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Exponential Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtexp(5,0.1)
ptexp(5,0.1)
qtexp(0.5,0.1)
rtexp(100,0.1)
}
