% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIndex.R
\docType{methods}
\name{getIndex}
\alias{getIndex}
\alias{getIndex,Index-method}
\alias{getIndex,ANY-method}
\title{Retrieve index value based on dates.}
\usage{
getIndex(object, ...)

\S4method{getIndex}{Index}(object, dates)
}
\arguments{
\item{object}{Index Object}

\item{...}{Additional function arguments}

\item{dates}{dates to get index information}
}
\description{
\code{getIndex} get a time index to reflect inflation, underwriting cycle or seasonality.
}
\examples{
xindex <- new("Index", indexID = "IDX1", tabulate = FALSE, annualizedRate = 0.03)
xindex<-setIndex(xindex)
xindex@monthlyIndex
dates<-as.Date("2015-12-31")
getIndex(xindex,dates)
}
