% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DevFac.R
\docType{class}
\name{DevFac-class}
\alias{DevFac-class}
\title{An S4 class to represent a loss development schedule.}
\description{
An S4 class to represent a loss development schedule.
}
\section{Slots}{

\describe{
\item{\code{FacID}}{A character string to identify the loss development schedule.}

\item{\code{FacModel}}{A boolean to indicate whether the loss development schedule is described as a model (TRUE) or a list of value (FALSE).}

\item{\code{fun}}{A character string that indicates the model format in link function. Currently identity(linear), inverse(reciprocal linear), log(exponential), and exponential(loglinear) link functions(models) are supported. It is only used when model == TRUE.}

\item{\code{distType}}{A character string that indicates the distribution of development factors. Currently normal, lognormal, and gamma distributions are supported. It is only used when model == FALSE.}

\item{\code{xname}}{A vector that includes the names of explanatory variables. They will have to be matched exactly to the claim data file. It is only used when model == TRUE.}

\item{\code{paras}}{A vector that contains the parameters of the model. It is only used when model == TRUE.}

\item{\code{meanList}}{A vector that contains the mean yearly development factor if distribution type is Normal. It is mu for Lognormal distribution and shape for Gamma distribution. It is only used when model == FALSE.}

\item{\code{volList}}{A vector that contains the volatility of yearly development factor if distribution type is Normal. It is sigma for Lognormal distribution and scale for Gamma distribution. It is used for simulating IBNER factors. It is only used when model == FALSE.}
}}

