% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_default.R
\name{carx.formula}
\alias{carx.formula}
\title{A formula interface to the \code{carx} method}
\usage{
\method{carx}{formula}(formula, data = list(), ...)
}
\arguments{
\item{formula}{the formula.}

\item{data}{the data consisting of the \code{y}, \code{x}, \code{lcl},\code{ci}, and \code{ucl} objects;
can be a \code{list}, \code{data.frame}, or a \code{\link{cenTS}} object.}

\item{...}{other arguments supplied to \code{\link{carx.default}}.}
}
\description{
This interface will use the supplied \code{formula} and data provided by \code{data} and other arguments 
in \code{...} to invoke the \code{carx.default} method. This is the preferred way of calling the 
\code{carx.default} function. The data and censoring information are best passed to the function via
a \code{cenTS} object comprising 
\code{y}, \code{x}, \code{ci}, \code{lcl}, and \code{ucl}.
}
\examples{
dat = carxSim(nObs=100,seed=0)
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
}
\seealso{
\code{\link{cenTS}} on how to construct a \code{cenTS} object.
}

