% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_layer.R
\name{make_layer}
\alias{make_layer}
\title{Make a layer}
\usage{
make_layer(
  x,
  type = c("final_centers", "original_centers", "centers_translation",
    "final_graticule", "original_graticule")
)
}
\arguments{
\item{x}{a cartogramR object}

\item{type}{a character string giving the type of layer:
- "final_centers": if \code{method} is \code{dcn}, \link[sf:geos_unary]{sf::st_centroid}
is applied on deformed/cartogram region ; if \code{method} is
\code{gsm} or \code{gn} (ie flow based), initial "centers" are calculated
and the cartogram deformation is applied on
these "centers" giving the final_centers.
- "original_centers" if \code{method} is \code{dcn}, \link[sf:geos_unary]{sf::st_centroid}
is applied on original regions); if \code{method} is
\code{gsm} or \code{gn} (ie flow based), initial "centers" are calculated
using cartogramR \code{center} option see \link{cartogramR_options}.
- "centers_translation" linestring giving the movement of
centers due to the deformation used to have the cartogram
- "final_graticule" (method \code{gsm} or \code{gn}) graticule
obtained by the cartogram algorithm
- "original_graticule" (method \code{gsm} or \code{gn}) graticule
used by the cartogram algorithm}
}
\value{
a sfc object
}
\description{
Create a sfc object containing final centers, original centers,
centers displacement, original graticule or final graticule.
}
