% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gridanalysis.cartogramR.R
\name{plot.gridanalysis.cartogramR}
\alias{plot.gridanalysis.cartogramR}
\title{Plot a gridanalysis.cartogram object}
\usage{
\method{plot}{gridanalysis.cartogramR}(
  x,
  nthsmallest = 5,
  redrawxaxis = TRUE,
  type = "b",
  xlab = NULL,
  ylab = NULL,
  ylim = c(0, 20),
  ...
)
}
\arguments{
\item{x}{a gridanalysis.cartogram object}

\item{nthsmallest}{plot only  the nthsmallest values among all polygons}

\item{redrawxaxis}{if \code{TRUE} redraw ticks and labels of x axe at grid size on
log scale}

\item{type}{character string (length 1 vector) or vector of 1-character
strings indicating the type of plot for each polygons,
see \link[graphics:matplot]{graphics::matplot} for all possible \code{type}s.}

\item{xlab}{titles for x axe, as in \link[graphics:matplot]{graphics::matplot}.}

\item{ylab}{titles for y axe, as in \link[graphics:matplot]{graphics::matplot}.}

\item{ylim}{ranges of y axe, as in \link[graphics:matplot]{graphics::matplot}.}

\item{\\dots}{arguments passed to or from other methods.}
}
\value{
No return value, called for side effects
}
\description{
Plot a gridanalysis.cartogram object
}
\examples{
\donttest{
  data(usa)
  precarto <- precartogramR(usa, method="gsm", pf=1.2, verbose=TRUE)
  plot(precarto)
}

}
