% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp_sdm.R
\name{varImp_sdm}
\alias{varImp_sdm}
\title{Calculation of variable importance for models}
\usage{
varImp_sdm(m, id = NULL, ...)
}
\arguments{
\item{m}{A \code{models} or \code{input_sdm} object.}

\item{id}{Vector of model ids to filter varImp calculation.}

\item{...}{Parameters passing to caret::varImp().}
}
\value{
A \code{data.frame} with variable importance data.
}
\description{
This function retrieves variable importance as a function of ROC curves to each predictor.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="bioclim")

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "repeatedcv",
                                number = 2,
                                repeats = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i, algo = c("naive_bayes"), ctrl=ctrl_sdm) |>
suppressWarnings()

# Variable importance:
varImp_sdm(i)

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
