\name{dotplot.diff.resamples}
\alias{levelplot.diff.resamples}
\alias{densityplot.diff.resamples}
\alias{bwplot.diff.resamples}
\alias{dotplot.diff.resamples}
\title{Lattice Functions for Visualizing Resampling Differences}

\description{
Lattice functions for visualizing resampling result differences between models
}
\usage{
\method{densityplot}{diff.resamples}(x, data, metric = x$metric, ...)

\method{bwplot}{diff.resamples}(x, data, metric = x$metric, ...)

\method{levelplot}{diff.resamples}(x, data = NULL, metric = x$metric[1], what = "pvalues", ...)

\method{dotplot}{diff.resamples}(x, data = NULL, metric = x$metric[1], ...)

}
\arguments{
  \item{x}{an object generated by \code{\link{diff.resamples}}}
  \item{data}{Not used}
  \item{what}{\code{levelplot} only: display either the \code{"pvalues"} or \code{"differences"}}
  \item{metric}{a character string for which metrics to plot. Note: \code{dotplot} and \code{levelplot} require exactly two models whereas the other methods can plot more than two.}
  \item{\dots}{further arguments to pass to either \code{\link[lattice:histogram]{histogram}}, \code{\link[lattice:histogram]{densityplot}}, \code{\link[lattice:dotplot]{dotplot}} or \code{\link[lattice:levelplot]{levelplot}}}
}
\details{
\code{densityplot} and \code{bwplot} display univariate visualizations of the resampling distributions. \code{levelplot} displays the matrix of pair-wide comparisons. \code{dotplot} shows the differences along with their associated confidence intervals.
}
\value{
a lattice object
}

\author{Max Kuhn}

\seealso{
\code{\link{resamples}}, \code{\link{diff.resamples}}, \code{\link[lattice:bwplot]{bwplot}}, \code{\link[lattice:histogram]{densityplot}}, \code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:splom]{splom}}
}
\examples{
\dontrun{
#load(url("http://caret.r-forge.r-project.org/Classification_and_Regression_Training_files/exampleModels.RData"))

resamps <- resamples(list(CART = rpartFit,
                          CondInfTree = ctreeFit,
                          MARS = earthFit))
difs <- diff(resamps)

dotplot(difValues)

densityplot(difValues,
            metric = "RMSE",
            auto.key = TRUE,
            pch = "|")

bwplot(difValues,
       metric = "RMSE")

levelplot(difValues, what = "differences")

}
}

\keyword{hplot}
