% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_mood_test.R
\name{ard_stats_mood_test}
\alias{ard_stats_mood_test}
\title{ARD Mood Test}
\usage{
ard_stats_mood_test(data, by, variables, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to be compared. Independent tests will
be run for each variable.}

\item{...}{arguments passed to \code{mood.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Mood two sample test of scale. Note this not to be confused with
the Brown-Mood test of medians.
}
\details{
For the \code{ard_stats_mood_test()} function, the data is expected to be one row per subject.
The data is passed as \code{mood.test(data[[variable]] ~ data[[by]], ...)}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cards::ADSL |>
  ard_stats_mood_test(by = "SEX", variables = "AGE")
\dontshow{\}) # examplesIf}
}
