% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metal_emissions.R
\name{metal_emissions}
\alias{metal_emissions}
\title{Metal Emissions}
\usage{
metal_emissions(
  aluminuim_cans = 0,
  aluminuim_foil = 0,
  mixed_cans = 0,
  scrap = 0,
  steel_cans = 0,
  aluminuim_cans_WD = 0,
  aluminuim_foil_WD = 0,
  mixed_cans_WD = 0,
  scrap_WD = 0,
  steel_cans_WD = 0,
  waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  units = c("kg", "tonnes")
)
}
\arguments{
\item{aluminuim_cans}{Numeric value indicating the weight of aluminum cans. Default is \code{0}.}

\item{aluminuim_foil}{Numeric value indicating the weight of aluminum foil. Default is \code{0}.}

\item{mixed_cans}{Numeric value indicating the weight of mixed metal cans. Default is \code{0}.}

\item{scrap}{Numeric value indicating the weight of metal scrap. Default is \code{0}.}

\item{steel_cans}{Numeric value indicating the weight of steel cans. Default is \code{0}.}

\item{aluminuim_cans_WD}{Numeric value indicating the weight of aluminum cans disposed of using waste disposal methods. Default is \code{0}.}

\item{aluminuim_foil_WD}{Numeric value indicating the weight of aluminum foil disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_cans_WD}{Numeric value indicating the weight of mixed metal cans disposed of using waste disposal methods. Default is \code{0}.}

\item{scrap_WD}{Numeric value indicating the weight of metal scrap disposed of using waste disposal methods. Default is \code{0}.}

\item{steel_cans_WD}{Numeric value indicating the weight of steel cans disposed of using waste disposal methods. Default is \code{0}.}

\item{waste_disposal}{Character vector specifying the waste disposal method to use for calculating emissions. Possible values: "Closed-loop", "Combustion", "Landfill", "Open-loop". Default is "Closed-loop".
\code{"Open-loop"} is the process of recycling material into other products.
\code{"Closed-loop"} is the process of recycling material back into the same product.
\code{"Combustion"} energy is recovered from the waste through incineration and subsequent generation of electricity.
\code{"Landfill"} the product goes to landfill after use.}

\item{units}{Character vector specifying the units of the emissions output. Possible values: "kg", "tonnes". Default is "kg".}
}
\value{
The function returns the calculated CO2-equivalent emissions as a numeric value in tonnes.
}
\description{
This function calculates the emissions produced from different metal sources based on the specified inputs. It considers emissions from primary material production and waste disposal of various metal types.
}
\examples{
metal_emissions(aluminuim_cans = 1.4, units = "tonnes")
}
