% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carbon.R
\docType{data}
\name{carbon}
\alias{carbon}
\title{Carbon R6 class}
\description{
The Carbon generator creates a new \code{Carbon}-object, which is the class containing
all the app logic. The class is based on the \link[R6:R6Class]{R6} OO-system and
is thus reference-based with methods and data attached to each object, in
contrast to the more well known S3 and S4 systems.
}
\section{Initialization}{

A new 'Carbon'-object is initialized using the \code{new()} method on the generator:

\tabular{l}{
\code{x <- carbon$new(code = clipr::read_clip())}
}
}

\section{Fields}{


\if{html}{
\out{
<br>
<details>
<summary> <span title='Click to Expand'> <big> Public Fields </big> </span> </summary>
}
}

Description of fields of the R6 object that can be set by the user can be found
in the following \link[carbonate:carbon-fields]{page}.

\if{html}{
\out{
</details>
}
}
}

\section{Methods}{


\if{html}{
\out{
<br>
<details>
<summary> <span title='Click to Expand'> <big> Interacting with Browser </big> </span> </summary>
}
}

\tabular{ll}{
\link[carbonate:carbon-carbonate]{$carbonate} \tab Using RSelenium fetch the carbon image output \cr
\link[carbonate:.browse]{$browse} \tab open \link[carbonate:carbon-uri]{$uri} in the browser
}

\if{html}{
\out{
</details>
}
}

\if{html}{
\out{
<br>
<details>
<summary> <span title='Click to Expand'> <big> Aesthetics </big> </span> </summary>
}
}
\tabular{ll}{
\link[carbonate:carbon-set-fields]{$set_template} \tab set $template \cr
\link[carbonate:carbon-get-fields]{$get_templates} \tab get a list of possible templates \cr
\link[carbonate:carbon-set-fields]{$set_window_control_theme} \tab  set $windows_control_theme \cr
\link[carbonate:carbon-get-fields]{$get_windows_control_themes} \tab get a list of possible window control themes\cr
\link[carbonate:carbon-set-fields]{$set_font_family} \tab set $font_family\cr
\link[carbonate:carbon-get-fields]{$get_font_families} \tab get a list of possible fonts
}

\if{html}{
\out{
</details>
}
}

\if{html}{
\out{
<br>
<details>
<summary> <span title='Click to Expand'> <big> URI Building </big> </span> </summary>
}
}
\tabular{ll}{
\link[carbonate:carbon-uri]{$uri} \tab construct valid carbon.js uri \cr
\link[carbonate:carbon-options]{$options} \tab return all current carbon options\cr
\link[carbonate:carbon-encode]{$encode} \tab URL encode a string for the $uri \cr
\link[carbonate:carbon-tinyurl]{$tiny}  \tab Create tinyurl from \link[carbonate:carbon-uri]{$uri} \cr
\link[carbonate:carbon-rtweet]{$rtweet}  \tab Send tweets containing media generated from carbon
}

\if{html}{
\out{
</details>
}
}

\if{html}{
\out{
<br>
<details>
<summary> <span title='Click to Expand'> <big> Webdriver Settings </big> </span> </summary>
}
}
\tabular{ll}{
\link[carbonate:carbon-chrome]{$chromeOptions} \tab construct a chromeOptions object \cr
\link[carbonate:carbon-chrome]{$chrome_start} \tab start a chrome session \cr
\link[carbonate:carbon-chrome]{$chrome_stop} \tab stop a chrome session \cr
\link[carbonate:carbon-selenium]{$start} \tab start a RSelenium session \cr
\link[carbonate:carbon-selenium]{$stop} \tab stop a RSelenium session \cr
\link[carbonate:carbon-selenium]{$stop_all} \tab stop all active RSelenium sessions
}

\if{html}{
\out{
</details>
}
}
}

\keyword{datasets}
