% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbol.R
\name{symbol}
\alias{symbol}
\title{Create a symbol}
\usage{
symbol(x, ...)
}
\arguments{
\item{x}{Name to turn into symbol}

\item{\dots}{Assumptions like \code{positive = TRUE}}
}
\value{
A \code{caracas_symbol}
}
\description{
Find available assumptions at
\url{https://docs.sympy.org/latest/modules/core.html#module-sympy.core.assumptions}.
}
\examples{
if (has_sympy()) {
  x <- symbol("x")
  2*x
  
  x <- symbol("x", positive = TRUE)
  ask(x, "positive")
}

}
\seealso{
\code{\link[=as_sym]{as_sym()}}
}
\concept{caracas_symbol}
