% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feglm_control.R
\name{feglm_control}
\alias{feglm_control}
\title{Set \code{feglm} Control Parameters}
\usage{
feglm_control(
  dev_tol = 1e-06,
  center_tol = 1e-06,
  iter_max = 25L,
  iter_center_max = 10000L,
  iter_inner_max = 50L,
  iter_interrupt = 1000L,
  iter_ssr = 10L,
  limit = 10L,
  trace = FALSE,
  drop_pc = TRUE,
  keep_mx = FALSE
)
}
\arguments{
\item{dev_tol}{tolerance level for the first stopping condition of the
maximization routine. The stopping condition is based on the relative change
of the deviance in iteration \eqn{r} and can be expressed as follows:
\eqn{|dev_{r} - dev_{r - 1}| / (0.1 + |dev_{r}|) < tol}{|dev - devold| /
 (0.1 + |dev|) < tol}. The default is \code{1.0e-08}.}

\item{center_tol}{tolerance level for the stopping condition of the centering
algorithm. The stopping condition is based on the relative change of the
centered variable similar to the \code{'lfe'} package. The default is
\code{1.0e-08}.}

\item{iter_max}{unsigned integer indicating the maximum number of iterations
in the maximization routine. The default is \code{25L}.}

\item{iter_center_max}{unsigned integer indicating the maximum number of
iterations in the centering algorithm. The default is \code{10000L}.}

\item{iter_inner_max}{unsigned integer indicating the maximum number of
iterations in the inner loop of the centering algorithm. The default is
\code{50L}.}

\item{iter_interrupt}{unsigned integer indicating the maximum number of
iterations before the algorithm is interrupted. The default is \code{1000L}.}

\item{iter_ssr}{unsigned integer indicating the number of iterations
to skip before checking if the sum of squared residuals improves. The default
is \code{10L}.}

\item{limit}{unsigned integer indicating the maximum number of iterations of
\code{\link[MASS]{theta.ml}}. The default is \code{10L}.}

\item{trace}{logical indicating if output should be produced in each
iteration. Default is \code{FALSE}.}

\item{drop_pc}{logical indicating to drop observations that are perfectly
classified/separated and hence do not contribute to the log-likelihood. This
option is useful to reduce the computational costs of the maximization
problem and improves the numerical stability of the algorithm. Note that
dropping perfectly separated observations does not affect the estimates.
The default is \code{TRUE}.}

\item{keep_mx}{logical indicating if the centered regressor matrix should be
stored. The centered regressor matrix is required for some covariance
estimators, bias corrections, and average partial effects. This option saves
some computation time at the cost of memory. The default is \code{TRUE}.}
}
\value{
A named list of control parameters.
}
\description{
Set and change parameters used for fitting \code{\link{feglm}}.
Termination conditions are similar to \code{\link[stats]{glm}}.
}
\examples{
feglm_control(0.05, 0.05, 10L, 10L, TRUE, TRUE, TRUE)

}
\seealso{
\code{\link{feglm}}
}
