% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotModels.R
\name{PlotModels}
\alias{PlotModels}
\title{Plot results of capm model functions}
\usage{
PlotModels(model.out = NULL, variable = NULL, col = "red",
  col1 = c("cadetblue1", "yellow", "red"), col2 = c("blue", "darkgreen",
  "darkred"), x.label = "Years", y.label = NULL, legend.label = NULL,
  pop = NULL)
}
\arguments{
\item{model.out}{output of one of the function previously mentioned.}

\item{variable}{string to specify the variable to be ploted. 

For \code{\link{SolveSI}} function: 

"n" (population size).

"q" (proportion of sterilized animals). 

For \code{\link{SolveIASA}} function using only point estimates:

"f1" (owned intact females).

"fs1" (owned sterilized females).

"m1" (owned intact males).

"ms1" (owned sterilized males).

"f2" (unowned intact females).

"fs2" (unowned sterilized females).

"m2" (unowned intact males).

"ms2" (unowned sterilized males). 

"n1" (owned intact animals).

"ns1" (owned sterilized animals).

"n2" (unowned intact animals).

"ns2" (unowned sterilized animals).

"N1" (owned animals).

"N2" (unowned animals).

"N" (total population).

For \code{\link{SolveIASA}} function using *.range arguments:

"f" (intact females).

"fs" (sterilized females).

"m" (intact males).

"ms" (sterilized males).

"n" (intact animals).

"ns" (sterilized animals).

"N" (Total population stratified by reproductive status).

For \code{\link{SolveTC}} function: 

"n" (fertile animals).

"g" (sterilized animals).

"u" (cumulative of sterilized animals)}

\item{col}{string indicating the color of ploted line, when \code{s.range} is \code{NULL}.}

\item{col1}{\code{\link{character}} \code{\link{vector}} indicating the color of lowest (highest) population sizes (proportion of sterilized animals), when \code{s.range} is not \code{NULL}.}

\item{col2}{\code{\link{character}} \code{\link{vector}} indicating the color of highest (lowest) population sizes (proportion of sterilized animals), when \code{s.range} is not \code{NULL}.}

\item{x.label}{string with the name for x axis.}

\item{y.label}{string with the name for y axis.}

\item{legend.label}{string with the name of the legend, for plots of \code{\link{SolveIASA}} output.}

\item{pop}{value indicating the output of \code{\link{SolveIASA}} to be ploted. When \code{NULL} (default), plots for owned and unowned populations under scenarios created by immigartion rate are created. If \code{1}, the plots of owned population for the minimum immigartion rate are ploted. When \code{2}, the plots of unowned population for the minimum immigartion rate are ploted. If \code{3}, the plots of owned population for the maximum immigartion rate are ploted. When \code{4}, the plots of owned population for the maximum immigartion rate are ploted.}
}
\description{
Plot results of one of the following functions: \code{\link{SolveIASA}}, \code{\link{SolveSI}} or \code{\link{SolveTC}}.
}
\details{
Font size of saved plots is usually different to the font size seen in graphic browsers. Before changing font sizes, see the final result in saved (or preview) plots.
 
Other details of the plot can be modifyed using appropriate functions from \code{ggplot2} package.
}
\examples{
## IASA model

## Parameters and intial conditions.
data(dogs)
dogs_iasa <- GetDataIASA(dogs,
                         destination.label = "Pinhais",
                         total.estimate = 50444)

# Solve for point estimates.
solve_iasa_pt <- SolveIASA(pars = dogs_iasa$pars,
                           init = dogs_iasa$init,
                           time = 0:15,
                           alpha.owned = TRUE,
                           method = 'rk4')
solve_iasa_rg <- SolveIASA(pars = dogs_iasa$pars,
                           init = dogs_iasa$init, 
                           time = 0:10,
                           alpha.owned = TRUE,
                           s.range = seq(0, .4, l = 15), 
                           a.range = c(0, .2), 
                           alpha.range = c(0, .05),
                           v.range = c(0, .1),
                           method = 'rk4')

## Plot unowned population sizes using point estimates
\dontrun{
PlotModels(solve_iasa_pt, variable = "ns2")

## Plot all scenarios and change the label for the scenarios.
## Not run
PlotModels(solve_iasa_rg, variable = "ns")
}

}
\references{
Chang W (2012). R Graphics Cookbook. O'Reilly Media, Inc.

\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\link[deSolve]{plot.deSolve}.
}
