% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotHHxSpecies.R
\name{PlotHHxSpecies}
\alias{PlotHHxSpecies}
\title{Distribution of households according to the number of inhabitants one or more species}
\usage{
PlotHHxSpecies(dat = NULL, species = NULL, proportion = TRUE,
  x.label = "Individuals per household",
  y.label = "Proportion of households", legend = TRUE)
}
\arguments{
\item{dat}{\code{\link{data.frame}} with households as observation unit and columns with the number of individuals of the species of interest.}

\item{species}{names or positions of columns with species data.}

\item{proportion}{\code{\link{logical}}. If \code{TRUE} (default), the y axis will represent proportions, if \code{FALSE}, it would represent raw counts.}

\item{x.label}{title for x axis.}

\item{y.label}{title for y axis.}

\item{legend}{\code{\link{logical}}. If \code{TRUE} (default), the legend will be showed, if \code{FALSE}, it will be removed.}
}
\description{
Dodged bar plot of the distribution of households according to the number of inhabitants of one or more species.
}
\examples{
data(cluster_sample)
PlotHHxSpecies(cluster_sample, c("number_of_persons",
                                 "number_of_dogs",
                                 "number_of_cats"))

}
\references{
Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.
}
\seealso{
\link[ggplot2]{geom_bar}.
}
