% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_population.R
\name{write_population}
\alias{write_population}
\title{Save the cross data in R/qtl CSV format}
\usage{
write_population(
  data_obj,
  geno_obj,
  ref_allele = "A",
  na = NA,
  filename = "capeData.csv"
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{ref_allele}{a character, e.g., "A", that represents the reference allele in the data object}

\item{na}{either NA or a character used to represent a missing data value in the output}

\item{filename}{absolute or relative path to the output file's destination}
}
\value{
Writes a file to the destination path
}
\description{
This function writes out a cape object
in a csv format readable both by \code{\link{read_population}}
in Cape or by read.cross in R/qtl.
}
\examples{
\dontrun{
write_population(data_obj, geno_obj)
}

}
\references{
Broman et al. (2003) R/qtl: QTL mapping in experimental crosses. 
Bioinformatics 19:889-890 doi:10.1093/bioinformatics/btg112
}
