% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairscan_noKin.R
\name{pairscan_noKin}
\alias{pairscan_noKin}
\title{Perform pairscan without a kinship correction}
\usage{
pairscan_noKin(
  data_obj,
  pheno_mat,
  geno_mat,
  covar_table,
  marker_pairs,
  n_perm,
  verbose = FALSE,
  run_parallel = FALSE,
  n_cores = NULL
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{pheno_mat}{The matrix of trait values with individuals in rows
and traits in columns.}

\item{geno_mat}{The matrix of genotypes to be tested}

\item{covar_table}{The matrix of covariates with individuals in rows.}

\item{marker_pairs}{A two-column matrix containing the marker pairs
to be tested.}

\item{n_perm}{The number of permutations to be run}

\item{verbose}{A logical value indicating whether to 
print progress to the screen}

\item{run_parallel}{A logical value indicating 
whether parallel processing should be used}

\item{n_cores}{The number of cores to be used if run_parallel is TRUE}
}
\value{
This function calls \code{\link{one_pairscan_parallel}} and
returns results for each trait as an element in a list.
}
\description{
This internal function is called by \code{\link{pairscan}}
when no kinship correction is requested. It can be
compared to \code{\link{pairscan_kin}}. 
It fits pairwise linear models to estimate the effects of 
marker pairs on each trait.
}
\keyword{internal}
