% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_marker_chr.R
\name{get_marker_chr}
\alias{get_marker_chr}
\title{Get chromosome numbers for markers}
\usage{
get_marker_chr(data_obj, markers, character_names = TRUE)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{markers}{A vector of marker names}

\item{character_names}{A logical value indicating whether
the marker names are characters (TRUE) or numbers (FALSE)}
}
\value{
A vector the same length as the input markers vector
indicating which chromosome each marker in markers lives on.
}
\description{
Given a vector of marker names or numbers, this 
function returns the chromosome on which each 
marker lives.Covariates are assigned to chromosome 0.
}
\examples{
\dontrun{
marker_names <- dimnames(geno_obj)[[3]]
marker_chr <- get_marker_chr(data_obj, marker_names)
}

}
\keyword{internal}
