% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim_table_overview}
\alias{get_cansim_table_overview}
\title{Retrieve Statistics Canada data table overview text}
\usage{
get_cansim_table_overview(
  cansimTableNumber,
  language = "english",
  refresh = FALSE
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (default set to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}
}
\value{
none
}
\description{
Prints table overview information as console output. In order to display table overview information, the selected CANSIM table must be loaded entirely to display overview information. Overview information is printed in console an in English or French, as specified.
}
\examples{
\donttest{
get_cansim_table_overview("34-10-0013")
}
}
