% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{child_census_vectors}
\alias{child_census_vectors}
\title{List all child variables from vector hierarchical based on a (sub-)list of census
variables returned by
\code{list_census_vectors} or \code{search_census_vectors}.}
\usage{
child_census_vectors(vector_list, leaves_only = FALSE)
}
\arguments{
\item{vector_list}{The list of vectors to be used}

\item{leaves_only}{Boolean flag to indicate if only leaf vectors should be returned,
i.e. vectors that don't have children}
}
\description{
List all child variables from vector hierarchical based on a (sub-)list of census
variables returned by
\code{list_census_vectors} or \code{search_census_vectors}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

list_census_vectors("CA16") \%>\%
  filter(vector == "v_CA16_4092") \%>\%
  child_census_vectors(TRUE)
}
