% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vaccine-age-groups.R
\name{get_vaccine_age_groups}
\alias{get_vaccine_age_groups}
\title{Get vaccination reports by age group}
\usage{
get_vaccine_age_groups(
  split = c("overall", "province"),
  province = NULL,
  group = NULL,
  before = NULL,
  after = NULL
)
}
\arguments{
\item{split}{One of "overall", or "province" to specify how the
data is split. An "overall" report gives cumulative numbers across Canada.
Splitting by "province" returns all reports for all provinces/territories.}

\item{province}{One or more province/territory codes ("AB", "BC", "MB", "NB",
"NL", "NS", "NT", "NU", "ON", "PE", "QC", "SK", "YT") to get reports.
Upper, lower and mixed case strings are accepted.}

\item{group}{A specific age group to return, for example: "0-4", "05-11",
"30-39", "80+", "not_reported"}

\item{before}{Returns reports from only on or before the specified date,
in YYYY-MM-DD format.}

\item{after}{Returns reports from only on or after the specified date,
in YYYY-MM-DD format.}
}
\value{
A data frame with, one row per age group per date. Includes
a \code{province} variable if data is split by province.
}
\description{
Runs a GET request of vaccination data by age groups from the COVID-19
tracker API, and returns parsed data.
Via the \code{split} argument, data may be "overall" (all provinces/territories
combined), or by "province".
Alternatively, provide one or more two-letter codes (e.g. "AB") to \code{province}
to return reports for specific provinces.
}
\examples{

get_vaccine_age_groups()
get_vaccine_age_groups(split = "province")
get_vaccine_age_groups(province = c("AB", "SK"))
get_vaccine_age_groups(province = "NS", group = "18-29")
get_vaccine_age_groups(group = "80+", after = "2021-12-01")
}
