% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveyDashboard.R
\name{surveyDashboard}
\alias{surveyDashboard}
\title{Shiny dashboard for summarizing and analyzing camera trap survey data}
\usage{
surveyDashboard(
  CTtable,
  recordTable,
  stationCol,
  cameraCol = NULL,
  xcol,
  ycol,
  crs,
  setupCol,
  retrievalCol,
  hasProblems = FALSE,
  CTdateFormat = "ymd",
  camerasIndependent,
  speciesCol = "Species",
  recordDateTimeCol = "DateTimeOriginal",
  recordDateTimeFormat = "ymd HMS",
  timeZone = "UTC",
  exclude = NULL
)
}
\arguments{
\item{CTtable}{A data.frame containing the camera trap deployment information.}

\item{recordTable}{A data.frame containing the camera trap records.}

\item{stationCol}{The column name containing the camera trap station ID}

\item{cameraCol}{The column name containing the camera trap IDs (optional, only if 2 or more cameras per station)}

\item{xcol}{The column name containing the X coordinate of the camera trap station.}

\item{ycol}{The column name containing the Y coordinate of the camera trap station.}

\item{crs}{The coordinate reference system (CRS) of the camera trap data. Must be a valid argument to \code{\link[sf]{st_crs}}}

\item{setupCol}{The column name containing the camera trap deployment date (and time).}

\item{retrievalCol}{The column name containing the camera trap retrieval date (optionally date-time).}

\item{hasProblems}{A logical indicating whether there are periods of cameras malfunctioning}

\item{CTdateFormat}{The date format of the camera trap deployment and retrieval date and time (default: "ymd").}

\item{camerasIndependent}{logical. If multiple camera per station, are they independent?}

\item{speciesCol}{The column name containing the species names}

\item{recordDateTimeCol}{The column name containing the record date and time}

\item{recordDateTimeFormat}{The date/time format of \code{recordDateTimeCol}}

\item{timeZone}{Time zone of records in recordTable}

\item{exclude}{Species to be excluded from the data set}
}
\value{
A Shiny dashboard for camera trap survey data.
}
\description{
Open a Shiny dashboard to summarize a camera trapping survey. It provides an 
overview of the data, maps, can create and run occupancy models in unmarked, 
and plot species activity. 

Maps are interactive and can be panned, zoomed and queried. Users can choose 
a suitable basemap in the layers button.

For occupancy models, users can flexibly customize detection histories. Then 
the user can specify the model structure (by selecting site covariates on 
detection and occupancy probability from the camera trap table) and 
optionally including effort. Models are fitted automatically with unmarked. 
Response curves (marginal effect plots), model and parameter summaries are 
computed and updated automatically with every change to the model. 
Multiple models can be compared using model selection.
}
\note{
Current limitations include:

- supports only single-season data

- only single-species occupancy models

- no random or interaction effects in occupancy models

- no (spatial) model predictions yet (planned for Q4/2023)

- no support for spatial capture-recapture models (or anything related to individual IDs)

- only models in unmarked, no Bayesian models in ubms yet (likely to be included later)
}
\examples{

\dontrun{
data("camtraps")
data("recordTableSample")
 
  surveyDashboard(
    CTtable = camtraps,
    recordTable = recordTableSample,
    xcol = "utm_x",
    ycol = "utm_y",
    crs = "epsg:32650",      # = UTM50N (Sabah, Malaysian Borneo)
    stationCol = "Station",
    setupCol = "Setup_date",
    retrievalCol = "Retrieval_date",
    CTdateFormat = "dmy"
  )
  }
  
  

}
\author{
Juergen Niedballa
}
