% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{count_vec}
\alias{count_vec}
\title{Count values of a vector}
\usage{
count_vec(x, sort = TRUE)
}
\arguments{
\item{x}{A vector to check.}

\item{sort}{logical; if TRUE will sort output in descending order of \code{n}}
}
\value{
A tibble, with counts of each \code{value} in \code{n}.
}
\description{
A version of \code{\link[dplyr:count]{dplyr::count()}} which uses \code{\link[tibble:enframe]{tibble::enframe()}} to count the
number of values in a single vector.
}
\examples{
count_vec(x = rivers)
count_vec(x = sample(x = state.name, size = 1000, replace = TRUE))
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_in}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
