% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_fire_danger_levels.R
\name{validate_fire_danger_levels}
\alias{validate_fire_danger_levels}
\title{validate_fire_danger_levels}
\usage{
validate_fire_danger_levels(
  fire_index,
  observation,
  fire_threshold,
  obs_threshold
)
}
\arguments{
\item{fire_index}{RasterBrick containing the fire index (only one variable)}

\item{observation}{RasterBrick containing the observation (only one variable)}

\item{fire_threshold}{threshold to use to select relevant fire indices}

\item{obs_threshold}{threshold to use to select relevant observations}
}
\value{
A list of two binary vectors: obs (observations) and
pred (predictions).
}
\description{
This function compares observed and modelled fire data and
return a contingency table summarising the hit rates, false alarms, misses
and correct negatives. The validation can be done using various thresholds
and input data.
}
\examples{
\dontrun{
 # Read example data
 r_risico <- readRDS(system.file("extdata", "RISICO_raster.rds",
                                 package = "caliver"))
 # Set missing crs
 raster::crs(r_risico) <- "+proj=longlat +datum=WGS84 +no_defs"

  # Generate obs and pred binary vectors
  validate_fire_danger_levels(fire_index = r_risico,
                              observation = r_risico * 2,
                              fire_threshold = 0.5,
                              obs_threshold = 0.5)

}

}
