% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_external.R
\name{create_mean}
\alias{create_mean}
\title{Create the inputs to evaluate the quality of mean estimations}
\usage{
create_mean(
  var,
  domains = NULL,
  subpop = NULL,
  design,
  ci = FALSE,
  ess = FALSE,
  ajuste_ene = FALSE,
  standard_eval = FALSE,
  rm.na = FALSE,
  deff = FALSE,
  rel_error = FALSE,
  unweighted = FALSE,
  eclac_input = FALSE
)
}
\arguments{
\item{var}{numeric variable within the  \code{dataframe}.}

\item{domains}{domains to be estimated separated by the + character.}

\item{subpop}{integer dummy variable to filter the dataframe}

\item{design}{complex design created by \code{survey} package}

\item{ci}{\code{boolean} indicating if the confidence intervals must be calculated}

\item{ess}{\code{boolean} Effective sample size}

\item{ajuste_ene}{\code{boolean} indicating if an adjustment for the sampling-frame transition period must be used}

\item{standard_eval}{\code{boolean} Indicating if the function is wrapped inside a function, if \code{TRUE} avoid lazy eval errors}

\item{rm.na}{\code{boolean} Remove NA if it is required}

\item{deff}{\code{boolean} Design effect}

\item{rel_error}{\code{boolean} Relative error}

\item{unweighted}{\code{boolean} Add non weighted count if it is required}

\item{eclac_input}{\code{boolean} return eclac inputs}
}
\value{
\code{dataframe} that contains the inputs and all domains to be evaluated
}
\description{
\code{create_mean} generates a \code{dataframe} with the following elements: mean,
degrees of freedom, sample size and coefficient of variation. The function allows
grouping in several domains.
}
\examples{
dc <- survey::svydesign(ids = ~varunit, strata = ~varstrat, data = epf_personas, weights = ~fe)
create_mean("gastot_hd", "zona+sexo",  design = dc)
}
