% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite.R
\name{hermite}
\alias{hermite}
\title{Hermite Polynomials}
\usage{
hermite(order, sigma = 1, var = "x")
}
\arguments{
\item{order}{integer. The order of the Hermite polynomial.}

\item{sigma}{the covariance matrix of the Gaussian kernel.}

\item{var}{character. The variables of the polynomial.}
}
\value{
list of Hermite polynomials with components
\describe{
 \item{f}{the Hermite polynomial.}
 \item{order}{the order of the Hermite polynomial.}
 \item{terms}{data.frame containing the variables, coefficients and degrees of each term in the Hermite polynomial.}
}
}
\description{
Computes univariate and multivariate Hermite polynomials.
}
\details{
Hermite polynomials are obtained by successive differentiation of the Gaussian kernel
\deqn{H_{\nu}(x,\Sigma) = exp \Bigl( \frac{1}{2} x^\dagger \Sigma x \Bigl) (- \partial_x )^\nu exp \Bigl( -\frac{1}{2} x^\dagger \Sigma x \Bigl)}
where \eqn{\Sigma} is a d-dimensional square matrix and \eqn{\nu=(\nu_1, ..., \nu_d)} is the vector representing the order of differentiation for each variable.
}
\examples{
# univariate Hermite polynomials up to order 3
hermite(3)

# univariate Hermite polynomials with variable z
hermite(3, var = 'z')

# multivariate Hermite polynomials up to order 2
hermite(order = 2, 
        sigma = matrix(c(1,0,0,1), nrow = 2), 
        var = c('z1', 'z2'))

}
