% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_test_MGD.R
\name{calculateDistance}
\alias{calculateDistance}
\title{Internal: Matrix difference}
\usage{
calculateDistance(
  .matrices = NULL, 
  .distance = args_default()$.distance
  )
}
\arguments{
\item{.matrices}{A list of at least two matrices.}

\item{.distance}{Character string. A distance measure. One of: "\emph{geodesic}"
or "\emph{squared_euclidian}". Defaults to "\emph{geodesic}".}
}
\value{
A numeric vector of length one containing the (arithmetic) mean of
the differences between all possible pairs of matrices supplied via \code{.matrices}.
}
\description{
Calculates the average of the differences between all possible pairs of
(symmetric) matrices in a list using a given distance measure.
}
\details{
\code{.matrices} must be a list of at least two matrices. If more than two matrices
are supplied the arithmetic mean of the differences between all possible pairs of
(symmetric) matrices in a list is computed. Mathematically this is
n chose 2. Hence, supplying a large number of matrices will
become computationally challenging.

Currently two distance measures are supported:
\describe{
\item{\code{geodesic}}{(Default) The geodesic distance.}
\item{\code{squared_euclidian}}{The squared Euclidian distance}
}
}
\keyword{internal}
