% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{Russett}
\alias{Russett}
\title{Data: Russett}
\format{A data frame containing the following variables for 47 countries:
\describe{
\item{\code{gini}}{The Gini index of concentration}
\item{\code{farm}}{The percentage of landholders who collectively occupy
one-half of all the agricultural land (starting with the farmers
with the smallest plots of land and working toward the largest)}
\item{\code{rent}}{The percentage of the total number of farms that rent all
their land. Transformation: ln (x + 1)}
\item{\code{gnpr}}{The 1955 gross national product per capita in U.S. dollars.
Transformation: ln (x)}
\item{\code{labo}}{The percentage of the labor force employed in agriculture.
Transformation: ln (x)}
\item{\code{inst}}{Instability of personnel based on the term of office of the
chief executive. Transformation: exp (x - 16.3)}
\item{\code{ecks}}{The total number of politically motivated violent incidents,
from plots to protracted guerrilla warfare. Transformation: ln (x + 1)}
\item{\code{deat}}{The number of people killed as a result of internal group
violence per 1,000,000 people. Transformation: ln (x + 1)}
\item{\code{stab}}{One if the country has a stable democracy, and zero otherwise}
\item{\code{dict}}{One if the country experiences a dictatorship, and zero otherwise}
}}
\source{
From: \insertCite{Henseler2020;textual}{cSEM}
}
\usage{
Russett
}
\description{
A data frame containing 10 variables with 47 observations.
}
\details{
The dataset was initially compiled by \insertCite{Russett1964;textual}{cSEM},
discussed and reprinted by \insertCite{Gifi1990;textual}{cSEM},
and partially transformed by \insertCite{Tenenhaus2011;textual}{cSEM}.
It is also used in \insertCite{Henseler2020;textual}{cSEM} for demonstration
purposes.
}
\examples{
#============================================================================
# Example is taken from Henseler (2020)
#============================================================================
model_Russett="
# Composite model
AgrIneq <~ gini + farm + rent
IndDev  <~ gnpr + labo
PolInst <~ inst + ecks + deat + stab + dict

# Structural model
PolInst ~ AgrIneq + IndDev
"

out <- csem(.data = Russett, .model = model_Russett,
            .PLS_weight_scheme_inner = 'factorial',
            .tolerance = 1e-06
)

}
\references{
\insertAllCited{}
}
\keyword{datasets}
