% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{LancelotMiltgenetal2016}
\alias{LancelotMiltgenetal2016}
\title{Data: LancelotMiltgenetal2016}
\format{An object of class \code{data.frame} with 1090 rows and 11 columns.}
\source{
This data has been collected through a cooperation with the European Commission
Joint Research Center Institute for Prospective Technological Studies, contract
“Young People and Emerging Digital Services: An Exploratory Survey on Motivations,
Perceptions, and Acceptance of Risk” (EC JRC Contract IPTS No: 150876-2007 F1ED-FR).
}
\usage{
LancelotMiltgenetal2016
}
\description{
A data frame containing 10 variables with 1090 observations.
}
\details{
The data was analysed by \insertCite{Lancelot-Miltgen2016;textual}{cSEM}
to study young consumers’ adoption intentions of a location tracker technology
in the light of privacy concerns. It is also used in
\insertCite{Henseler2020;textual}{cSEM} for demonstration purposes (Tutorial 9).
}
\examples{
#============================================================================
# Example is taken from Henseler (2020)
#============================================================================
model_Med <- "
# Reflective measurement model
Trust =~ trust1 + trust2
PrCon =~ privcon1 + privcon2 + privcon3 + privcon4
Risk  =~ risk1 + risk2 + risk3
Int   =~ intent1 + intent2

# Structural model
Int   ~ Trust + PrCon + Risk
Risk  ~ Trust + PrCon
Trust ~ PrCon
"

out <- csem(.data = LancelotMiltgenetal2016, .model = model_Med,
            .PLS_weight_scheme_inner = 'factorial',
            .tolerance = 1e-06
)

}
\references{
\insertAllCited{}
}
\keyword{datasets}
