% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{weighted.quantile.inflation}
\alias{weighted.quantile.inflation}
\title{Weighted quantile estimator through case inflation}
\usage{
weighted.quantile.inflation(
  x,
  probs,
  weights = NULL,
  degree = 3,
  cutoff = 1e+07
)
}
\arguments{
\item{x}{A numerical vector}

\item{probs}{Numerical vector of quantiles}

\item{weights}{A numerical vector with weights; should have the same length as x.}

\item{degree}{power parameter for case inflation (default = 3, equaling factor 1000)
If no weights are provided (NULL), it falls back to the base quantile function, type 7}

\item{cutoff}{stop criterion for the sum of standardized weights to switch to Harrell-Davis,
default = 1000000}
}
\value{
the quantiles
}
\description{
Applies weighted ranking numerically by inflating cases according to weight. This function
will be resource intensive, if inflated cases get too high and in this cases, it switches
to the parametric Harrell-Davis estimator.
}
