% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{rankByGroup}
\alias{rankByGroup}
\title{Determine the norm scores of the participants in each subsample}
\usage{
rankByGroup(data, group = "group", raw = "raw", method = 4,
  scale = "T", descend = FALSE, descriptives = TRUE)
}
\arguments{
\item{data}{data.frame with norm sample data}

\item{group}{name of the grouping variable (default 'group'), e. g. grade, setting
group to FALSE cancels grouping (data is treated as one group)}

\item{raw}{name of the raw value variable (default 'raw')}

\item{method}{Ranking method in case of bindings, please provide an index,
choosing from the following methods: 1 = Blom (1958), 2 = Tukey (1949),
3 = Van der Warden (1952), 4 = Rankit (default), 5 = Levenbach (1953),
6 = Filliben (1975), 7 = Yu & Huang (2001)}

\item{scale}{type of norm scale, either T (default), IQ, z or percentile (= no
transformation); a double vector with the mean and standard deviation can as well,
be provided f. e. c(10, 3) for Wechsler scale index points}

\item{descend}{ranking order (default descent = FALSE): inverses the
ranking order with higher raw scores getting lower norm scores; relevant
for example when norming error scores, where lower scores mean higher
performance}

\item{descriptives}{If set to TRUE (default), information in n, mean, median and
standard deviation per group is added to each observation}
}
\value{
the dataset with the percentiles and norm scales per group
}
\description{
This is the initial step, usually done in all kinds of test norming projects,
after the scale is constructed and the norm sample is established. First,
the data is grouped according to a grouping variable and afterwards, the percentile
for each raw value is retrieved. The percentile can be used for the modeling
procedure, but in case, the samples to not deviate too much from normality,
T, IQ or z scores can be computed via a normal rank procedure based on the
inverse cumulative normal distribution. In case of bindings, we use the medium rank
and there are different methods for estimating the percentiles (default RankIt).
}
\examples{
# Transformation with default parameters: RandIt and converting to T scores
data.elfe <- rankByGroup(elfe, group = "group")

# Transformation into Wechsler scores with Yu & Huang (2001) ranking procedure
data.elfe <- rankByGroup(elfe, group = "group", method = 7, scale=c(10, 3))

# cNORM can as well be used for conventional norming
# The group variable has to be set to NULL when ranking the group in this case
d <- rankByGroup(elfe, raw="raw", group=FALSE)
d <- computePowers(d)
m <- bestModel(d)
rawTable(0, model = m) # please use an arbitrary value for age when generating the tables
}
\seealso{
rankBySlidingWindow, computePowers
}
