% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{xAxis}
\alias{xAxis}
\alias{xAxis.c3}
\alias{yAxis}
\alias{yAxis.c3}
\alias{y2Axis}
\alias{y2Axis.c3}
\title{C3 Axis}
\usage{
xAxis(c3, show = TRUE, type = "indexed", localtime = NULL,
  categories = NULL, max = NULL, min = NULL, padding = list(),
  height = NULL, extent = NULL, label = NULL, ...)

\method{xAxis}{c3}(c3, show = TRUE, type = "indexed", localtime = NULL,
  categories = NULL, max = NULL, min = NULL, padding = list(),
  height = NULL, extent = NULL, label = NULL, ...)

yAxis(c3, show = TRUE, inner = NULL, max = NULL, min = NULL,
  padding = NULL, inverted = NULL, center = NULL, label = NULL, ...)

\method{yAxis}{c3}(c3, show = TRUE, inner = NULL, max = NULL,
  min = NULL, padding = NULL, inverted = NULL, center = NULL,
  label = NULL, ...)

y2Axis(c3, show = TRUE, inner = NULL, max = NULL, min = NULL,
  padding = NULL, inverted = NULL, center = NULL, label = NULL, ...)

\method{y2Axis}{c3}(c3, show = TRUE, inner = NULL, max = NULL,
  min = NULL, padding = NULL, inverted = NULL, center = NULL,
  label = NULL, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{show}{boolean}

\item{type}{character on of 'indexed', timeseries' or 'category'}

\item{localtime}{boolean}

\item{categories}{character vector. Can be used to modify axis labels. Not needed if
already defined in data}

\item{max}{numeric set value of axis range}

\item{min}{numeric set value of axis range}

\item{padding}{list with options:
\itemize{
 \item{left}{: numeric pixels}
 \item{right}{: numeric pixels}
}}

\item{height}{integer pixels to set height of axis}

\item{extent}{vector or character function (wrapped in JS()) that returns a vector of values}

\item{label}{can be character or list with options (see \href{http://c3js.org/reference.html#axis-x-label}{c3 axis-x-label}):
\itemize{
 \item{text}{: character}
 \item{position}{: character}
}
label position options for horixontal axis are:
\itemize{
 \item{inner-right}
 \item{inner-center}
 \item{inner-left}
 \item{outer-right}
 \item{outer-center}
 \item{outer-left}
}
label position options for vertical axis are:
\itemize{
 \item{inner-top}
 \item{inner-middle}
 \item{inner-bottom}
 \item{outer-top}
 \item{outer-middle}
 \item{outer-bottom}
}}

\item{...}{additional options passed to the axis object}

\item{inner}{boolean show axis inside chart (Y and Y2 axis only)}

\item{inverted}{boolean TRUE will reverse the direction of the axis (Y and Y2 axis only)}

\item{center}{integer or numeric value for center line (Y and Y2 axis only)}
}
\value{
c3
}
\description{
Modify plot elements that relate to the axis.
}
\examples{
data.frame(a=c(1,2,3,2),b=c(2,3,1,5)) \%>\%
  c3(axes = list(a = 'y',
                 b = 'y2')) \%>\%
   xAxis(label = list(text = 'testing',
                      position = 'inner-center')) \%>\%
   y2Axis()

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{c3}},
  \code{\link{grid}}, \code{\link{legend}},
  \code{\link{region}}, \code{\link{subchart}},
  \code{\link{tooltip}}, \code{\link{zoom}}
}
