% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_export.R
\name{ZoteroExport}
\alias{ZoteroExport}
\title{Export Zotero items to bibliography}
\usage{
ZoteroExport(
  zotero,
  csl.type = NULL,
  csl.name = "style",
  locale = "en-US",
  format = "biblatex",
  bib.name = "references",
  save.data = FALSE,
  save.path = NULL,
  silent = FALSE
)
}
\arguments{
\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items)}

\item{csl.type}{Specify a CSL type to Official repository for Citation Style
Language (CSL), Default: NULL}

\item{csl.name}{Name of saved CSL file, Default: 'style'}

\item{locale}{Desired language format of bibliography, Default: 'en-US'}

\item{format}{Export format of Zotero items, Default: 'biblatex'}

\item{bib.name}{Name of exported bibliography, Default: 'references'}

\item{save.data}{Save data (e.g., bibliography) to disk, Default: FALSE}

\item{save.path}{Location to store data on disk, Default: NULL}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}
}
\value{
A list with information on the specified Zotero library (e.g.,
  exported items, bibliography and citations)
}
\description{
Export Zotero items to a specified format (e.g., BibLaTeX) using
  a CSL format (e.g., APA7)
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Define Zotero list according to default group
  zotero = Zotero(
    user = FALSE,
    id = "4827927",
    api = "RqlAmlH5l1KPghfCseAq1sQ1",
    item.type = "-attachment || note",
    max.result = 1,
    library = TRUE
  )

  # Export 1 items from the default group
  example <- ZoteroExport(
    zotero
  )
  # Display exported
  cat(example$export, fill = 80)
}
}
\seealso{
\code{\link[dplyr]{select}}
 \code{\link[tidyselect]{where}}
}
