% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doi_datacite.R
\name{DoiDatacite}
\alias{DoiDatacite}
\title{Wrangle DataCite metadata into Zotero-type format}
\usage{
DoiDatacite(data, meta)
}
\arguments{
\item{data}{XML data from DataCite containing metadata}

\item{meta}{A list collecting all metadata used to create , Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
Query DataCite by DOI and fetch metadata
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # `DoiDatacite` is called from `ZoteroDoi` (if item found)
  example <- ZoteroDoi("https://doi.org/10.13140/rg.2.2.31532.74885")

  # Use `ZoteroIndex` to print
  # Print index using `ZoteroIndex`
  ZoteroIndex(example) |>
    dplyr::select(name) |>
    print(width = 80)
  # Display catalog
  example$libraryCatalog
}
}
