% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adult_bmi.R
\name{adult_bmi}
\alias{adult_bmi}
\title{Get BMI prevalence results from Adult Weight Change Model}
\usage{
adult_bmi(weight, days = seq(0, length(weight[["Time"]]) - 1, length.out =
  25), group = rep(1, nrow(weight[["BMI_Category"]])),
  design = svydesign(ids = ~1, weights = rep(1,
  nrow(weight[["BMI_Category"]])), data =
  as.data.frame(weight[["BMI_Category"]])), confidence = 0.95)
}
\arguments{
\item{weight}{(list) List from \code{\link{adult_weight}}

\strong{ Optional }}

\item{days}{(vector) Vector of days in which to compute the estimates}

\item{group}{(vector) Variable in which to group the results.}

\item{design}{A \code{survey.design} object. See \code{\link[survey]{svydesign}} 
for additional information on design objects.}

\item{confidence}{(numeric) Confidence level (\code{default = 0.95})}
}
\description{
Gets survey proportions \code{\link[survey]{svytable}}, standard error and
confidence interval estimates of BMI from \code{\link{adult_weight}}.
}
\details{
The default \code{design} is that of simple random sampling.
}
\examples{
#EXAMPLE 1: RANDOM SAMPLE MODELLING
#--------------------------------------------------------

#Antropometric data
weights <- c(45, 67, 58, 67, 81)
heights <- c(1.30, 1.73, 1.77, 1.92, 1.73)
ages    <- c(45, 23, 66, 44, 23)
sexes   <- c("male", "female", "female", "male", "male") 

#Matrix of energy consumption reduction: 
EIchange <- rbind(rep(-100, 365), rep(-200, 365), rep(-200, 365), 
                  rep(-123, 365), rep(-50, 365))

#Create weight change model
model_weight <- adult_weight(weights, heights, ages, sexes, 
                             EIchange)
                             
#Calculate proportions
adult_bmi(model_weight)

#EXAMPLE 2: Survey data
#-------------------------------------------------------
set.seed(7423)

#Data frame for use in survey
probs   <- runif(10, 20, 60)
datasvy <- data.frame(
  id    = 1:10,
  bw    = runif(10,60,90),
  ht    = runif(10, 1.5, 2),
  age   = runif(10, 18, 80),
  sex   = sample(c("male","female"),10, replace = TRUE),
  kcal  = runif(10, 2000, 3000),
  group = sample(c(0,1), 10, replace = TRUE),
  svyw  = probs/sum(probs))

#Days to model
days <- 365

#Energy intake matrix
EIchange <- matrix(NA, ncol = days, nrow = 0)
for(i in 1:nrow(datasvy)){
    EIchange <- rbind(EIchange, rep(datasvy$kcal[i], days))
}

#Calculate weight change                   
weight <- adult_weight(datasvy$bw, datasvy$ht, datasvy$age, 
                          datasvy$sex, EIchange)


#Create survey design using survey package                           
design <- survey::svydesign(id = ~id, weights = datasvy$svyw, 
data = datasvy)
   
#' #Group to calculate means
group  <- datasvy$group     

#Calculate survey mean and variance for 25 days
adult_bmi(weight, design = design, group = group)
 
}
\author{
Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}

Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}
}
