% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{financial_history_appendix}
\alias{financial_history_appendix}
\alias{trading_day}
\title{Time points and Financial Events}
\format{
A vector \code{trading_day} saves dates of \link{etf_vix}.
}
\usage{
trading_day
}
\description{
This page describes about some important financial events in 20th century.
This might give some hint when cutting data and why we provides datasets in limited period.
}
\section{Outline}{
\itemize{
\item 2000: Dot-com bubble
\item 2001: September 11 terror and Enron scandal
\item 2003: Iraq war (until 2011)
\item 2007 to 2008: Financial crisis (US)
\itemize{
\item 2007: Subprime morgage crisis
\item 2008: Bankrupcy of Lehman Brothers
}
\item 2010 to 2016: European sovereign dept crisis
\itemize{
\item 2010: Greek debt crisis
\item 2011: Italian default
\item 2015: Greek default
\item 2016: Brexit
}
\item 2018: US-China trade war
\item 2019: Brexit
\item 2020: COVID-19
}
}

\section{About Datasets in this package}{
\link{etf_vix} ranges from 2012-01-09 to 2015-06-27 (only weekdays).
Each year corresponds to Italian default and Grexit.
If you wonder the exact vector of the date, see \link{trading_day} vector.
}

\section{Notice}{
If you want other time period, see codes in the Github repo for the dataset: \href{https://github.com/ygeunkim/bvhar/blob/master/data-raw/etf_vix.R}{ygeunkim/bvhar/data-raw/etf_vix.R}

You can download what you want by changing a few lines.
}

\keyword{datasets}
\keyword{internal}
