% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.R
\name{AIC.varlse}
\alias{AIC.varlse}
\alias{AIC.vharlse}
\alias{AIC.bvarmn}
\alias{AIC.bvarflat}
\alias{AIC.bvharmn}
\title{Akaike's Information Criterion of Multivariate Time Series Model}
\usage{
\method{AIC}{varlse}(object, ...)

\method{AIC}{vharlse}(object, ...)

\method{AIC}{bvarmn}(object, ...)

\method{AIC}{bvarflat}(object, ...)

\method{AIC}{bvharmn}(object, ...)
}
\arguments{
\item{object}{Model fit}

\item{...}{not used}
}
\value{
AIC value.
}
\description{
Compute AIC of VAR(p), VHAR, BVAR(p), and BVHAR
}
\details{
Let \eqn{\tilde{\Sigma}_e} be the MLE
and let \eqn{\hat{\Sigma}_e} be the unbiased estimator (\code{covmat}) for \eqn{\Sigma_e}.
Note that

\deqn{\tilde{\Sigma}_e = \frac{s - k}{s} \hat{\Sigma}_e}

Then

\deqn{AIC(p) = \log \det \Sigma_e + \frac{2}{s}(\text{number of freely estimated parameters})}

where the number of freely estimated parameters is \eqn{mk}, i.e. \eqn{pm^2} or \eqn{pm^2 + m}.
}
\references{
Akaike, H. (1969). \emph{Fitting autoregressive models for prediction}. Ann Inst Stat Math 21, 243–247.

Akaike, H. (1971). \emph{Autoregressive model fitting for control}. Ann Inst Stat Math 23, 163–180.

Akaike H. (1974). \emph{A new look at the statistical model identification}. IEEE Transactions on Automatic Control, vol. 19, no. 6, pp. 716-723.

Akaike H. (1998). \emph{Information Theory and an Extension of the Maximum Likelihood Principle}. In: Parzen E., Tanabe K., Kitagawa G. (eds) Selected Papers of Hirotugu Akaike. Springer Series in Statistics (Perspectives in Statistics). Springer, New York, NY.

Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
