% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{composite}
\alias{composite}
\title{Composite fire events in fhx object returning composited object with prominent fires.}
\usage{
composite(x, filter_prop = 0.25, filter_min = 2, injury_event = FALSE,
  comp_name = "COMP")
}
\arguments{
\item{x}{An fhx instance.}

\item{filter_prop}{The proportion of fire events to recording series needed in order to be considered. Default is 0.25.}

\item{filter_min}{The minimum number of recording series needed to be considered a fire event. Default is 2 recording series.}

\item{injury_event}{Boolean indicating whether injuries should be considered events. Default is FALSE.}

\item{comp_name}{Character vector of the series name for the returned fhx object composite series. Default is 'COMP'.}
}
\value{
An fhx object representing the composited series.
}
\description{
Composite fire events in fhx object returning composited object with prominent fires.
}
\examples{
data(lgr2)
composite(lgr2)

# Use with composite to get composite years:
comp <- composite(pgm, comp_name = 'pgm')
event_yrs <- get_event_years(comp)[['pgm']]
print(event_yrs)

}

