% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_jobsuche.R
\name{jobsuche_logo}
\alias{jobsuche_logo}
\title{Fetch Jobsuche employer logo}
\usage{
jobsuche_logo(hash_id, safe = TRUE, refresh = FALSE)
}
\arguments{
\item{hash_id}{Logo hash id.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with raw logo bytes.
}
\description{
Fetch Jobsuche employer logo
}
\details{
Returns the raw logo bytes for a given employer hash id. Use this together
with listings returned by \code{\link[=jobsuche_search]{jobsuche_search()}} or \code{\link[=jobsuche_search_app]{jobsuche_search_app()}}.

See https://jobsuche.api.bund.dev for API documentation.
}
\examples{
\dontrun{
Sys.setenv(JOBBOERSE_API_KEY = "jobboerse-jobsuche")
bunddev_auth_set("jobsuche", type = "api_key", env_var = "JOBBOERSE_API_KEY")
logo <- jobsuche_logo("abc123")
}

}
\seealso{
\code{\link[=jobsuche_search]{jobsuche_search()}} for listings and \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} for auth setup.
}
