% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_circle.R
\name{buffer_circle}
\alias{buffer_circle}
\title{A circule function}
\usage{
buffer_circle(point, radius, ...)
}
\arguments{
\item{point}{Cente point of the buffer, must equal to true in: \code{sf::st_is(point, "POINT")}}

\item{radius}{Radius of the buffer (numeric)}

\item{...}{Further arguments to give to \code{sf::st_buffer()}}
}
\value{
An object of class \code{sfc_POLYGON}
}
\description{
Creates a circular buffer. Wrapper around sf::st_buffer()
}
\examples{
example_point = sf::st_point(c(1,2))
example_point = sf::st_sfc(example_point)
example_point = sf::st_sf(example_point)

buffer_circle(example_point, 200) -> circular_buffer
plot(circular_buffer)
}
\keyword{circle}
