% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_wedge.R
\name{buffer_wedge}
\alias{buffer_wedge}
\title{A wedge Function}
\usage{
buffer_wedge(point, radius, degree, degree_width)
}
\arguments{
\item{point}{Centre point of the buffer, must equal to true in: \code{sf::st_is(point, "POINT")}}

\item{radius}{Radius of the buffer (numeric)}

\item{degree}{The angle at which the wedge is centred (clockwise). Must be between 0 and 360 (numeric)}

\item{degree_width}{Width of the wedge. Must be between 0 and 360 (numeric)}
}
\value{
An object of class \code{sfc_POLYGON}
}
\description{
Creates a wedge polygon
}
\examples{
example_point = sf::st_point(c(1,2))
example_point = sf::st_sfc(example_point)
example_point = sf::st_sf(example_point)
buffer_wedge(example_point, 200, 90, 45) -> wedge_shaped_buffer
plot(wedge_shaped_buffer)
}
\keyword{wedge}
