Prune = function(ET,SIN){

  ####
  #1. Initial value
  ####
  splitVariable=ET$splitVariable
  cutoff=ET$cutoff
  marker=ET$marker

  node.hat=ET$node.hat
  marker.hat=ET$marker.hat

  internal=ET$internal
  terminal=ET$terminal

  eta=ET$eta

  ####
  # 2. Update tree structure
  ####
  RC.SIN=2*SIN+1 #right child node number for SIN
  LC.SIN=2*SIN   #left

  #2.1. delete feature and cutoff value for SIN
  splitVariable[SIN]=NA
  cutoff[SIN]=NA
  idx=(node.hat==RC.SIN|node.hat==LC.SIN)        #idx, i.e. those who belong to terminal node=2*STN or 2*SIN+1
  eta[SIN]=NA
  node.hat[idx]=SIN

  #2.2. select marker
  sel.marker=marker[SIN]                         #prune and previous selected marker
  marker[LC.SIN]=marker[RC.SIN]=sel.marker
  marker.hat[idx]=marker[SIN]                    #select marker for each subject

  #2.3. updated internal & terminal nodes
  internal=setdiff(internal,SIN)
  terminal=sort(c(setdiff(terminal,c(LC.SIN,RC.SIN)),SIN))

  ####
  # 3. summary
  ####
  ET$splitVariable=splitVariable
  ET$cutoff=cutoff

  ET$marker=marker
  ET$node.hat=node.hat
  ET$marker.hat=marker.hat

  ET$internal=internal
  ET$terminal=terminal

  ET$numNodes=length(ET$terminal)

  ET$SIN=SIN
  ET$size.cond=TRUE

  return(ET)
}

