% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtergm.R
\name{createMtergm}
\alias{createMtergm}
\title{Constructor for \linkS4class{mtergm} objects}
\usage{
createMtergm(
  coef,
  se,
  pval,
  nobs,
  time.steps,
  formula,
  formula2,
  auto.adjust,
  offset,
  directed,
  bipartite,
  estimate,
  loglik,
  aic,
  bic,
  ergm,
  nvertices,
  data
)
}
\arguments{
\item{coef}{Object of class \code{"numeric"}. The coefficients.}

\item{se}{Standard errors.}

\item{pval}{The p-values.}

\item{nobs}{Object of class \code{"numeric"}. Number of observations.}

\item{time.steps}{Object of class \code{"numeric"}. Number of time steps.}

\item{formula}{Object of class \code{"formula"}. The original model formula
(without indices for the time steps).}

\item{formula2}{The revised formula with the object references after applying
the \code{\link{tergmprepare}} function.}

\item{auto.adjust}{Object of class \code{"logical"}. Indicates whether
automatic adjustment of dimensions was done before estimation.}

\item{offset}{Object of class \code{"logical"}. Indicates whether an offset
matrix with structural zeros was used.}

\item{directed}{Object of class \code{"logical"}. Are the dependent networks
directed?}

\item{bipartite}{Object of class \code{"logical"}. Are the dependent networks
bipartite?}

\item{estimate}{Estimate: either MCMC MLE or MPLE.}

\item{loglik}{Log likelihood of the MLE.}

\item{aic}{Akaike's Information Criterion.}

\item{bic}{Bayesian Information Criterion.}

\item{ergm}{The original \code{ergm} object as estimated by the
\code{\link[ergm]{ergm}} function in the \pkg{ergm} package.}

\item{nvertices}{Number of vertices.}

\item{data}{The data after processing by the \code{\link{tergmprepare}}
function.}
}
\description{
Constructor for \linkS4class{mtergm} objects.
}
\details{
Create an S4 \linkS4class{mtergm} object using this constructor function.
}
\seealso{
Other tergm-classes: 
\code{\link{btergm-class}},
\code{\link{createBtergm}()},
\code{\link{createTbergm}()},
\code{\link{mtergm-class}},
\code{\link{tbergm-class}}
}
\author{
Philip Leifeld
}
\concept{tergm-classes}
