% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mcmc.R
\name{plot.mcmc_output}
\alias{plot.mcmc_output}
\title{Trace and Density Plots for \code{mcmc_output}}
\usage{
\method{plot}{mcmc_output}(x, ...)
}
\arguments{
\item{x}{Object of class \code{mcmc_output} from \code{\link{run_mcmc}}.}

\item{...}{Further arguments to \link[bayesplot:MCMC-combos]{bayesplot::mcmc_combo}.}
}
\value{
The output object from \link[bayesplot:MCMC-combos]{bayesplot::mcmc_combo}.
}
\description{
Plots the trace and density plots of the hyperparameters theta from the MCMC
run by \code{\link{run_mcmc}}.
}
\details{
For further visualization (of the states), you can extract the posterior
samples with \code{as.data.frame} and \code{as_draws} methods to be used for example
with the \code{bayesplot} or \code{ggplot2} packages.
}
\note{
For IS-MCMC, these plots correspond to the approximate (non-weighted)
samples
.
}
\examples{
data("negbin_model")
# Note the very small number of iterations, so the plots look bad
plot(negbin_model)
}
\seealso{
\code{\link{check_diagnostics}} for a quick diagnostics statistics
of the model.
}
