% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_gibbs_s3.R
\name{plot.psd}
\alias{plot.psd}
\title{Plot method for psd class}
\usage{
\method{plot}{psd}(x, legend.loc = "topright", ylog = TRUE, ...)
}
\arguments{
\item{x}{an object of class psd}

\item{legend.loc}{location of legend out of "topright" (default), "topleft", "bottomright", "bottomleft".  If set to NA then no legend will be produced}

\item{ylog}{logical value (default is TRUE) to determine if PSD (y-axis) should be on natural log scale}

\item{...}{other graphical parameters from the plot.default function}
}
\value{
plot of the estimate of the (log) PSD
}
\description{
This function plots the log periodogram, log posterior median PSD, and log 90\% credible region PSD.  The x-axis uses angular frequency and the y-axis is plotted on the log scale.  The PSD at the zero frequency is removed from the plot.  If the time series is even length, the PSD at the last frequency is also removed from the plot.
}
\examples{
\dontrun{

set.seed(12345)

# Simulate AR(4) data
n = 2 ^ 7
ar.ex = c(0.9, -0.9, 0.9, -0.9)
data = arima.sim(n, model = list(ar = ar.ex))
data = data - mean(data)

# Run MCMC with linear B-spline prior (may take some time)
mcmc = gibbs_bspline(data, 10000, 5000, degree = 1)

# Plot result
plot(mcmc)

# Plot result on original scale with title
plot(mcmc, ylog = FALSE, main = "Estimate of PSD using the linear B-spline prior")
}
}
\seealso{
\link{gibbs_bspline}
}
