% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{ibsp}
\alias{ibsp}
\title{Indefinite integral of B-spline}
\usage{
ibsp(f, const = 0, nint = 1L)
}
\arguments{
\item{f}{Function, B-spline such as returned by \code{smbsp()} or \code{par2bsp()}}

\item{const}{Numeric scalar or vector of length \code{ncol(qw)} where
qw is weight matrix of f. Defines starting value of weights for indefinite
integral (0 by default).}

\item{nint}{Integer scalar >= 0, defines how many times to take integral (1 by default)}
}
\value{
Function calculating requested integral
}
\description{
Indefinite integral of B-spline
}
\details{
If f is B-spline, then following identity is held: Dbsp(ibsp(f)) is identical to f.
Generally, it does not work in the other sens: ibsp(Dbsp(f)) is not f
but not very far. If we can get an appropriate constant C=f(min(x)) then
we can assert that ibsp(Dbsp(f), const=C) is the same as f.
}
