% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_list.R
\name{bs_get_list}
\alias{bs_get_list}
\title{Get a view of a list}
\usage{
bs_get_list(
  list,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{list}{Character vector, length 1. Reference of the list record to get.}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of lists
}
\description{
Get a view of a list
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getList.json}{graph/getList.json (2025-03-20)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-11-25)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_list('at://did:plc:ragtjsm2j2vknwkz3zp4oxrd/app.bsky.graph.list/3kmokjyuflk2g')
bs_get_list('at://did:plc:hgyzg2hn6zxpqokmp5c2xrdo/app.bsky.graph.list/3laygnmmcfc2x')
\dontshow{\}) # examplesIf}
}
\concept{graph}
